#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266WebServer.h>
#include <SoftwareSerial.h>

void web_page();
void server_Setup();
void new_GETSETUP();
void new_TURBO();/*протип функции ускорения*/
void new_GO();
void new_STOP();
void new_BACK();
void new_LEFT();
void new_RIGHT();
void new_PUSH();

int MAX_POSSIBLE_V=1024;
int MAX_VPODRULIVANIE=1000;
int MAX_V_DISCRET_POVOROT=1000;
int MAX_V=1000; //600
int MIN_V=600; //300
int ACCEL = 1;
int ACCEL_ROTATION = 1;
int ACCEL_STEP = 10;
int ACCEL_PODRULIVANIE = 1;
int DELAY_PODRULIVANIE = 0;

int ENA = 16; // ENA=16 для 101 с глючным пином, ENA=4 для всех остальных
int IN1 = 0; 
int IN2 = 2;

int ENB = 14;
int IN3 = 12; 
int IN4 = 13;

int SolenoidPIN = 15;//D8





const char* ssid = "botnetcam";
const char* password = "12345678990";

ESP8266WebServer server(80);   //instantiate server at port 80 (http port)
SoftwareSerial btSerial(D1, D2); 


String page="";

void setup(void) {
  pinMode(ENA, OUTPUT);
  pinMode(IN1, OUTPUT);
  pinMode(IN2, OUTPUT);

  pinMode(ENB, OUTPUT);
  pinMode(IN3, OUTPUT);
  pinMode(IN4, OUTPUT);
   
  
  // put your setup code here, to run once:
  pinMode(SolenoidPIN,OUTPUT);
  digitalWrite(SolenoidPIN, LOW);
  
  delay(1000);
  Serial.begin(115200);//монитор серийного порта 
  btSerial.begin(9600);
  WiFi.begin(ssid, password); //begin WiFi connection
  Serial.println("");

  // Wait for connection
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

/////////////////////////////////////
 
/*тут мы вызываем функции*/
  new_page();
  new_TURBO();
  new_GO();
  new_STOP();
  new_GETSETUP();
  new_SETUP();
  new_BACK();
  new_LEFT();
  new_RIGHT();
  new_PUSH();
  
  
  server.begin();
  Serial.println("Web server started!");
  

}/*Конец функции setup*/





void new_GETSETUP(){
  server.on("/GETSETUP", [](){
  //usage: http://ip/GETSETUP
  server.send(200,"text/html","BOT "+String(WiFi.localIP()[3])+" calibration values:<br>MAX_V= " + String(MAX_V) + ";<br>MIN_V= " + String(MIN_V)); 
  });}
void new_page(){
   page = "<!DOCTYPE html><html><head><title></title><script src=\"https://ajax.googleapis.com/ajax/libs/jquery/2.2.0/jquery.min.js\"></script><script type=\"text/javascript\" src=\"http://w3.org.ua/jquery/podklyuchenie-biblioteki-jquery-4-sposoba/\"></script><script type=\"text/javascript\"> $(document).ready(function(){ $(\"#GO\").click(function(){         $(\"#START,#START2\").load(\"/GO\");}); $(\"#BACK\").click(function(){         $(\"#START,#START2\").load(\"/BACK\");}); $(\"#STOP\").click(function(){         $(\"#START,#START2\").load(\"/STOP\");}); $(\"#LEFT\").click(function(){         $(\"#START,#START2\").load(\"/LEFT\");});$(\"#RIGHT\").click(function(){         $(\"#START,#START2\").load(\"/RIGHT\");}); $(\"#TURBO\").click(function(){         $(\"#START,#START2\").load(\"/TURBO\");}); $(\"#PUSH\").click(function(){         $(\"#START,#START2\").load(\"/PUSH\");}); });</script><style type=\"text/css\">.second{margin-top:15px;}.third{  margin-top:15px;}.efect3{transition:all 0.5s ease;}.efect{ transition:all 1s ease;}.efect2{ transition:all 0.5s ease;}body{background:url(\'https://static8.depositphotos.com/1040018/998/i/450/depositphotos_9980449-stock-photo-black-background-of-circle-pattern.jpg\');}.efect3:hover{box-shadow: inset 0 0 0 10px red;}.efect:hover{  box-shadow: inset 0 0 0 4px red;} .efect2:hover{  box-shadow: inset 0 0 0 3px black;} #GO{position: relative;right: 36px;color :red;border:1px solid red;background-color:black;width:50px;height: 30px;outline: none;}#BACK{position: relative;left:97px;width: 50px;height: 30px;color:red;background-color:black;border:1px solid red;outline: none;}#START:hover{font-size:80px;}#START2:hover{font-size:80px;}#START{position: relative;right:200px;color:red;width:175px;height:150px;background-color:black;border:2px solid red; outline: none;font-size: 400%;} #START2{position: relative;right:-200px;color:red;width:175px;height:150px;background-color:black;border:2px solid red; outline: none;font-size: 400%;} #STOP{position: relative;right:50px;color:black;width:65px;height:40px;background-color:red;border:2px solid black; outline: none;}#RIGHT{ position: relative; right:-100px;color:red;width: 50px;height: 30px;background-color:black;border:1px solid red;outline: none;} #LEFT{position: relative; right:33px;color:red;width: 50px;height: 30px;background-color:black;border:1px solid red; outline: none;}#PUSH{position: relative; right: 1px;color:red;width: 50px;height: 30px;background-color:black;border:1px solid red; outline: none;}#TURBO{position: relative;right:50px; color:red;width: 60px;height: 30px;background-color:black;border:1px solid black ; outline: none;</style></head><body>  <center><h1 style=\"color:red;\">Echpo4mac</h1><div class=\"first\"><button class=\"efect\" id=\"GO\" >GO</button><button class=\"efect\" id= \"BACK\">BACK</button><button class=\"efect\" id=\"TURBO\">TURBO</button></div> <div class=\"second\"><button class=\"efect\" id=\"LEFT\">LEFT</button><button class=\"efect\" id=\"RIGHT\">RIGHT</button><button class=\"efect2\" id=\"STOP\">STOP</button></div>   <div class=\" third\"><button class=\"efect\" id=\"PUSH\">PUSH</button></div>  <div class=\"fourth \"><button class=\"efect3\" id=\"START\">&#9680;</button><button class=\"efect3\"id=\"START2\">&#9681;</button></div>  </center></body></html>";//объявляем переменнную типа стринг

///////////////////

server.on("/", [](){
    server.send(200, "text/html", page);
  });
}
void new_TURBO(){
server.on("/TURBO", [](){
    server.send(200, "text/html", "&uArr;</center></span>");
    analogWrite(ENA, 0);
    analogWrite(ENB, 0);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MIN_V;i<MAX_POSSIBLE_V;i++)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, i);
        delay(ACCEL);     
       }
  });}


void new_SETUP(){
server.on("/SETUP", [](){
  //usage: http://ip/SETUP?maxv=1000&minv=500
  String maxv_val = server.arg("maxv");
  String minv_val = server.arg("minv");
  MAX_V = maxv_val.toInt();
  MIN_V = minv_val.toInt(); 
  server.send(200,"text/html","BOT "+String(WiFi.localIP()[3])+"<br>WARNING: Possible value of MAX_V=1024;<br><br> Current set up:<br> MAX_V= " + String(MAX_V) + "<br>MIN_V= " + String(MIN_V)); 
  });}

  /*Это часть кода отвечает за скорость*/
 void new_GO(){
   
  server.on("/GO", [](){
    server.send(200, "text/html", "&uarr;</center></span>");
    analogWrite(ENA, 0);
    analogWrite(ENB, 0);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V;i>MIN_V;i--)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, i);
        delay(ACCEL);     
       }
    });}
     /*Это часть кода отвечает за задний ход*/
    void new_BACK(){
   server.on("/BACK", [](){
    server.send(200, "text/html", "&darr;</font></center>");
    analogWrite(ENA, 0);
    analogWrite(ENB, 0);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, HIGH);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, HIGH);
    for(int i=MAX_V;i>MIN_V;i--)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, i);
        delay(ACCEL);     
       }
  });}
    /*Это часть кода отвечает за остановку*/ 
     void new_STOP(){
 server.on("/STOP", [](){
    server.send(200, "text/html", "&#10006;</font></center>");
    for(int i=MIN_V;i>-1;i--)
       {
         analogWrite(ENA, i);
         analogWrite(ENB, i);
         delay(ACCEL);
       }
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });}
  /*Это часть кода отвечает за порачивание в право*/ 
   void new_RIGHT(){
  server.on("/RIGHT", [](){
    server.send(200, "text/html", "&rarr;</font></center>");
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V_DISCRET_POVOROT;i>-1;i=i-3)
      {
         analogWrite(ENA, i);
         delay(ACCEL_ROTATION);
       }
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
    /*Это часть кода отвечает за порачивание в влево*/
      
     });}
  /*   void new_LEFT(){ 
    server.on("/LEFT", [](){
    server.send(200, "text/html", "&larr;</font></center>");
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V_DISCRET_POVOROT;i>-1;i=i-3)
       {
        analogWrite(ENB, i);
        delay(ACCEL_ROTATION);
       }
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });}*/
  void new_PUSH(){
  server.on("/PUSH", [](){
    server.send(200, "text/html", "&#10163;</font></center>");
    // Тимур: удар толкателя
    digitalWrite(SolenoidPIN, HIGH);// соленоид вперед
    delay(100);
    digitalWrite(SolenoidPIN, LOW);// соленоид назад
  });}
   
   void new_LEFT(){ 
    server.on("/LEFT", [](){
    server.send(200, "text/html", "&larr;</font></center>");
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, HIGH);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V_DISCRET_POVOROT;i>-1;i=i-3)
       {
        analogWrite(ENB, i);
        delay(ACCEL_ROTATION);
       }
       
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
    
   });}
   

void loop(void) {
  // put your main code here, to run repeatedly:
   server.handleClient();
     if (btSerial.available() > 0) {
     char data = btSerial.read();
     Serial.println("->"+String(data));

   switch (data)
     {
      case 'F':
     // Serial.println("------------------go");
      analogWrite(ENA, MIN_V);
      analogWrite(ENB, MIN_V);
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, HIGH);
      digitalWrite(IN4, LOW);
      break;
      case 'B':
     // Serial.println("------------------back");
      analogWrite(ENA, MIN_V);
      analogWrite(ENB, MIN_V);
      digitalWrite(IN1, LOW);
      digitalWrite(IN2, HIGH);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, HIGH);
      break;
      case 'R':      
     // Serial.println("------------------right");
      analogWrite(ENA, MAX_V);
      analogWrite(ENB, MAX_V);
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, LOW);
      break;
      case 'L':      
    //  Serial.println("------------------left");
      analogWrite(ENA, MAX_V);
      analogWrite(ENB, MAX_V);
      digitalWrite(IN1, LOW);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, HIGH);
      digitalWrite(IN4, LOW);
      break;
      case 'X':
      digitalWrite(SolenoidPIN, HIGH);// соленоид вперед
      delay(100);
      digitalWrite(SolenoidPIN, LOW);// соленоид назад
      break;
      case 'I':      
   //   Serial.println("------------------fr");
      analogWrite(ENA, MIN_V+300);
      analogWrite(ENB, MIN_V-300);
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, HIGH);
      digitalWrite(IN4, LOW);
      break;
      case 'G':      
     // Serial.println("------------------fl");
      analogWrite(ENA, MIN_V-300);
      analogWrite(ENB, MIN_V+300);
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, HIGH);
      digitalWrite(IN4, LOW);
      break;
      case 'J':      
     // Serial.println("------------------br");
      analogWrite(ENA, MIN_V+300);
      analogWrite(ENB, MIN_V-300);
      digitalWrite(IN1, LOW);
      digitalWrite(IN2, HIGH);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, HIGH);
      break;
      case 'H':      
      //Serial.println("------------------bl");
      analogWrite(ENA, MIN_V-300);
      analogWrite(ENB, MIN_V+300);
      digitalWrite(IN1, LOW);
      digitalWrite(IN2, HIGH);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, HIGH);
      break;
      case 'S':
      //Serial.println("------------------>stop");
      digitalWrite(IN1, LOW);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, LOW);
      break;
      
    default:
      break;
      }
     }

}
