#include <SoftwareSerial.h>
#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266WebServer.h>

int MAX_POSSIBLE_V=1024;
int MAX_VPODRULIVANIE=1000;
int MAX_V_DISCRET_POVOROT=700;
int MAX_V=600; //600
int MIN_V=300; //300
int ACCEL = 5; //1
int ACCEL_ROTATION = 2; //1
int ACCEL_STEP = 100;
int ACCEL_PODRULIVANIE = 3; //3
int DELAY_PODRULIVANIE = 250; //0

int ENA = 16; // ENA=16 для 101 с глючным пином, ENA=4 для всех остальных
int IN1 = 0; 
int IN2 = 2;

int ENB = 14;
int IN3 = 12; 
int IN4 = 13;

int SolenoidPIN = 15; //D8

const char* ssid = "botnetcam";
const char* password = "12345678990";
 
ESP8266WebServer server(80);   //instantiate server at port 80 (http port)
SoftwareSerial btSerial(D1, D2);
 
String page = "";
void setup(void){

  pinMode(ENA, OUTPUT);
  pinMode(IN1, OUTPUT);
  pinMode(IN2, OUTPUT);
  
  pinMode(ENB, OUTPUT);
  pinMode(IN3, OUTPUT);
  pinMode(IN4, OUTPUT);

  pinMode(SolenoidPIN, OUTPUT); // пин для соленоида
  digitalWrite(SolenoidPIN, LOW); // выключаем соленоид чтобы не грелся
  
  //make the LED pin output and initially turned off
  //pinMode(LED_BUILTIN, OUTPUT);
  //digitalWrite(LED_BUILTIN, LOW);
   
  delay(1000);
  Serial.begin(9600);
  btSerial.begin(9600);
  WiFi.begin(ssid, password); //begin WiFi connection
  Serial.println("");
 
  // Wait for connection
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());
  
  //the HTML of the web page
  page = "<!DOCTYPE html><html><html lang='ru-RU'><head><meta charset='UTF-8'/><title></title><script type=\"text/javascript\" src=\"http://ajax.googleapis.com/ajax/libs/jquery/1.5/jquery.min.js\"></script><script type=\"text/javascript\">$(document).ready(function(){$(\"#GO\").click(function(){$(\".six\").load(\"/GO\");});$(\"#TURBO\").click(function(){$(\".six\").load(\"/TURBO\");});$(\"#GO1\").click(function(){$(\".six\").load(\"/GO1\");});$(\"#BACK1\").click(function(){$(\".six\").load(\"/BACK1\");});$(\"#UDAR\").click(function(){$(\".six\").load(\"/UDAR\");});$(\"#LEFT\").click(function(){$(\".six\").load(\"/LEFT\");});$(\"#LEFT2\").click(function(){$(\".six\").load(\"/LEFT2\");});$(\"#RIGHT2\").click(function(){$(\".six\").load(\"/RIGHT2\");});$(\"#STOP\").click(function(){$(\".six\").load(\"/STOP\"); });$(\"#BACK\").click(function(){$(\".six\").load(\"/BACK\");});$(\"#RIGHT\").click(function(){$(\".six\").load(\"/RIGHT\");})});</script><style type=\"text/css\">.moveColor {   width: 200px;   height: 70px;   background-color: black;   cursor: pointer;   position: relative;   overflow: hidden;     } .moveColor:before{   content: '';   position: absolute;   top: 0;   left: -100%;   width: 200%;   height: 100%;   background: linear-gradient(to right, rgba(0,0,255,1) 0%,rgba(255,140,140,1)50%,rgba(0,0,0,1) 50%,rgba(0,0,0,1) 100%);   transition: left .7s; } .moveColor:hover:before{   left: 0; } .block{   position: relative; }       button {   padding: 15px 25px;   font-size: 24px;   text-align: center;   cursor: pointer;   outline: none;   color:yellow;   background-color: #4CAF50;   border: none;   border-radius: 15px;   box-shadow: 0 9px #de6efbe6;  }    button:active {   background-color: #3e8e1;   box-shadow: 0 5px #666;   transform: translateY(4px); }button:focus{outline: none;}.six{position: relative;margin-right: 200px;margin-top: 30px;}p{font-family: 'Lato', sans-serif;font-size: 35px;line-height: 40px;color: blue;position: absolute;top: 17px;left: 550px;}html{ background-image: linear-gradient(to bottom, rgb(255, 255, 255), rgb(250, 239, 247), rgb(245, 222, 239), rgb(240, 206, 232), rgb(235, 189, 224), rgb(230, 173, 216), rgb(226, 156, 208), rgb(221, 140, 200), rgb(216, 123, 192), rgb(211, 107, 185), rgb(206, 90, 177), rgb(201, 74, 169));}}body {width: 100%;height: 100%;background:no-repeat;background-color: white; background-image: linear-gradient(to bottom, rgb(255, 255, 255), rgb(250, 239, 247), rgb(245, 222, 239), rgb(240, 206, 232), rgb(235, 189, 224), rgb(230, 173, 216), rgb(226, 156, 208), rgb(221, 140, 200), rgb(216, 123, 192), rgb(211, 107, 185), rgb(206, 90, 177), rgb(201, 74, 169));}.content {position: absolute ;top: 35px;right: 30%;transform: translate(-50%, -50%);height: 50px;overflow: hidden;font-family: 'Lato', sans-serif;font-size: 35px;line-height: 40px;color: #ecf0f1}.content__container {font-weight: 600;overflow: hidden;height: 40px;padding: 0 40px;}.content__container:before {content: '';left: 0;}.content__container:after {content: '';position: absolute;right: 0;}.content__container:after, .content__container:before {position: absolute;top: 0;color: black;<!-- отвечает за цвет рамок -->font-size: 42px;line-height: 40px;-webkit-animation-name: opacity;-webkit-animation-duration: 3s;-webkit-animation-iteration-count: infinite;animation-name: opacity;animation-duration: 3s;animation-iteration-count: infinite;}.content__container__text {display: inline;float: left;margin: 0;color:red;<!-- отвечает за цвет текста -->}.content__container__list {margin-top: 0;padding-left: 110px;text-align: left;list-style: none;-webkit-animation-name: change;-webkit-animation-duration: 12s;-webkit-animation-iteration-count: infinite;animation-name: change;animation-duration: 12s;animation-iteration-count: infinite;}.content__container__list__item {line-height: 40px;margin: 0;-}@-webkit-keyframes opacity {0%, 100% {opacity: 0;}50% {opacity: 1;}}@-webkit-keyframes change {0%, 12.66%, 100% transform: translate3d(0, 0, 0);}16.66%, 29.32% {transform: translate3d(0, -25%, 0);}33.32%, 45.98% {transform: translate3d(0, -50%, 0);}49.98%, 62.64% {transform: translate3d(0, -75%, 0);}66.64%, 79.3% {transform: translate3d(0, -50%, 0);}83.3%, 95.96% {transform: translate3d(0, -25%, 0);}}@-o-keyframes opacity {0%, 100% {opacity: 0;}50% {opacity: 1;}}@-o-keyframes change {0%, 12.66%, 100% {transform: translate3d(0, 0, 0);}16.66%, 29.32% {transform: translate3d(0, -25%, 0);}33.32%, 45.98% {transform: translate3d(0, -50%, 0);}49.98%, 62.64% {transform: translate3d(0, -75%, 0);}66.64%, 79.3% {transform: translate3d(0, -50%, 0);}83.3%, 95.96% {transform: translate3d(0, -25%, 0);}}@-moz-keyframes opacity {0%, 100% {opacity: 0;}50% {opacity: 1;}}@-moz-keyframes change {0%, 12.66%, 100% {transform: translate3d(0, 0, 0);}16.66%, 29.32% {transform: translate3d(0, -25%, 0);}33.32%, 45.98% {transform: translate3d(0, -50%, 0);}49.98%, 62.64% {transform: translate3d(0, -75%, 0);}66.64%, 79.3% {transform: translate3d(0, -50%, 0);}83.3%, 95.96% {transform: translate3d(0, -25%, 0);}}@keyframes opacity {0%, 100% {opacity: 0;}50% {opacity: 1;}}@keyframes change {0%, 12.66%, 100% {transform: translate3d(0, 0, 0);}16.66%, 29.32% {transform: translate3d(0, -25%, 0);}33.32%, 45.98% {transform: translate3d(0, -50%, 0);}49.98%, 62.64% {transform: translate3d(0, -75%, 0);}66.64%, 79.3% {transform: translate3d(0, -50%, 0);}83.3%, 95.96% {transform: translate3d(0, -25%, 0);}}.first{margin-right: 200px}#GO{width: 160px;}  </style>  <style type=\"text/css\">.second{margin-right: 200px;}#RIGHT{position:relative;right: 3px;}#LEFT{position:relative;left: 3px;}#STOP{position:relative;left: 0px;color:red;}#UDAR{position:relative;right: 3px;}</style><style type=\"text/css\">.third{margin-right: 200px;}#BACK{width: 160px;}</style><style type=\"text/css\">.fourth{margin-right: 200px;margin-top: 100px;}#TURBO{width: 160px;}  </style><style type=\"text/css\">.fifth{margin-right: 200px;}#UDAR{position:relative;}</style><style type=\"text/css\">h1{}</style><style type=\"text/css\">p{position: relative ;}button{width: 100px;height: 50px;border-radius: 40px;}</style></style><head><h3><p>ИЗОлента</p></h3><div class=\"content\"><div class=\"content__container\"><p class=\"content__container__text\"></p><ul class=\"content__container__list\"><li class=\"content__container__list__item\" style=\"color:#DAA520;\">диз:Анастасия</li><li class=\"content__container__list__item\"  style=\"color:#696969;\">лид:Даша</li><li class=\"content__container__list__item\" style=\"color:black;\">прог:Мишa</li><li class=\"content__container__list__item\" style=\"color:#4682B4;\">инж:Дарий</li></ul></div></div></head><body><center><div class=\"fourth\"><button class=\"moveColor\" id = \"TURBO\"><div class=\"block\">ТУРБО</div></button></div><div class=\"first\"><button class=\"moveColor\" id = \"GO1\"><div class=\"block\">кор.ВПЕРЁД</div></button><button class=\"moveColor\" id = \"GO\"><div class=\"block\">ВПЕРЁД</div></button><button class=\"moveColor\" id = \"BACK1\"><div class=\"block\">кор.НАЗАД</div></button></div><div class=\"second\"><button class=\"moveColor\" id = LEFT \"><div class=\"block\">ЛЕВО</div></button><button class=\"moveColor\" id = \"STOP\"><div class=\"block\">СТОП</div></button><button class=\"moveColor\" id = \"RIGHT\"><div class=\"block\">ПРАВО</div></button></div><div class=\"third\"><button class=\"moveColor\"  id = \"LEFT2\"><div class=\"block\">ЛЕВО2</div></button><button class=\"moveColor\"  id = \"BACK\"><div class=\"block\">НАЗАД</div></button><button class=\"moveColor\"  id = \"RIGHT2\"><div class=\"block\">ПРАВО2</div></button></div><div class=\"fifth\"><button class=\"moveColor\" id = \"UDAR\"><div class=\"block\">УДАР</div></button></div><div class=\"six\"><h1>---START---</h1></div></center></body></html>";
  
  
  
  server.on("/", [](){
    server.send(200, "text/html", page+"</h1></font></center>");
  });


  server.on("/SETUP", [](){
  //usage: http://ip/SETUP?maxv=1000&minv=500
  String maxv_val = server.arg("maxv");
  String minv_val = server.arg("minv");
  MAX_V = maxv_val.toInt();
  MIN_V = minv_val.toInt(); 
  server.send(200,"text/html","BOT "+String(WiFi.localIP()[3])+"<br>WARNING: Possible value of MAX_V=1024;<br><br> Current set up:<br> MAX_V= " + String(MAX_V) + "<br>MIN_V= " + String(MIN_V)); 
  });

  server.on("/GETSETUP", [](){
  //usage: http://ip/GETSETUP
  server.send(200,"text/html","BOT "+String(WiFi.localIP()[3])+" calibration values:<br>MAX_V= " + String(MAX_V) + ";<br>MIN_V= " + String(MIN_V)); 
  });


  server.on("/TURBO", [](){
    server.send(200, "text/html", /*page*/"<h1>&uarr;&uarr;</h1></font></center>");
    analogWrite(ENA, MIN_V);
    analogWrite(ENB, MIN_V);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MIN_V;i<MAX_POSSIBLE_V;i++)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, i);
        delay(ACCEL);     
       }
  });
  server.on("/UDAR", [](){
    server.send(200, "text/html", /*page*/"<h1>Т</h1></font></center>");
    // Тимур: удар толкателя
    digitalWrite(SolenoidPIN, HIGH);// соленоид вперед
    delay(100);
    digitalWrite(SolenoidPIN, LOW);// соленоид назад
  });
  
  server.on("/GO", [](){
    server.send(200, "text/html", /*page*/"<h1>&uarr;</h1></font></center>");
    
    analogWrite(ENA, MIN_V);
    analogWrite(ENB, MIN_V);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
  });

  server.on("/GO1", [](){
    server.send(200, "text/html", /*page*/"<h1>&uarr;</h1></font></center>");
    
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    delay(250);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
    
  });
server.on("/BACK1", [](){
    server.send(200, "text/html", /*page*/"<h1>&uarr;</h1></font></center>");
    
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, HIGH);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, HIGH);
    delay(250);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
    
  });





  
  server.on("/BACK", [](){
    server.send(200, "text/html", /*page*/"<h1>&darr;</h1></font></center>");
    analogWrite(ENA, MIN_V);
    analogWrite(ENB, MIN_V);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, HIGH);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, HIGH);
  });

  
  server.on("/STOP", [](){
    server.send(200, "text/html", /*page*/"<h1>XXX</h1></font></center>");
    digitalWrite(IN1, LOW); // Резкий стоп
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });
  server.on("/RIGHT", [](){
    server.send(200, "text/html", /*page*/"<h1>&rarr;</h1></font></center>");
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V_DISCRET_POVOROT;i>-1;i=i-3)
       {
         analogWrite(ENA, i);
         delay(ACCEL_ROTATION);
       }
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });
    server.on("/LEFT", [](){
    server.send(200, "text/html", /*page*/"<h1>&larr;</h1></font></center>");
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V_DISCRET_POVOROT;i>-1;i=i-3)
       {
        analogWrite(ENB, i);
        delay(ACCEL_ROTATION);
       }
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });



//----------------------- Podrul--


 server.on("/LEFT2", [](){
    server.send(200, "text/html", /*page*/"<h1>&uarr;&larr;</h1></font></center>");
    for(int i=MIN_V;i<MAX_VPODRULIVANIE+1;i=i+ACCEL_STEP)
       {
        analogWrite(ENB, i);   // ускоряем вращение правого ряда моторов
        analogWrite(ENA, 2*MIN_V-i); // замедление вращения левого ряда моторов
        delay(ACCEL_PODRULIVANIE);
       }   
    delay(DELAY_PODRULIVANIE); 
    for(int i=MAX_VPODRULIVANIE;i>MIN_V-1;i=i-ACCEL_STEP)
       {
        analogWrite(ENB, i);
        analogWrite(ENA, 2*MIN_V-i);
        delay(ACCEL_PODRULIVANIE);
       }
       
  });
    server.on("/RIGHT2", [](){
    server.send(200, "text/html", /*page+*/ "<h1>%uarr;&rarr;</h1></font></center>");
    for(int i=MIN_V;i<MAX_VPODRULIVANIE+1;i=i+ACCEL_STEP)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, 2*MIN_V-i);
        delay(ACCEL_PODRULIVANIE);
       }   
    delay(DELAY_PODRULIVANIE);
    for(int i=MAX_VPODRULIVANIE;i>MIN_V-1;i=i-ACCEL_STEP)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, 2*MIN_V-i);
        delay(ACCEL_PODRULIVANIE);
       }
  });

//--------------------------------- end podrul ---
  
  server.begin();
  Serial.println("Web server started!");
}
  bool t = false;
 
void loop(void){
  server.handleClient();
  if (btSerial.available() > 0) 
     {    
      char data = btSerial.read();  // СЃС‡РёС‚Р°С‚СЊ РґР°РЅРЅС‹Рµ РёР· HC-05
      Serial.println("->"+String(data));
      switch (data){
        case 'S':
        digitalWrite(IN1, LOW);
        digitalWrite(IN2, LOW);
        digitalWrite(IN3, LOW);
        digitalWrite(IN4, LOW);
        break;

        case 'F':
        if(t == false){
        analogWrite(ENA, MIN_V);
        analogWrite(ENB, MIN_V);
        }
        else if(t == true){
        analogWrite(ENA, MAX_V);
        analogWrite(ENB, MAX_V);
        }
        digitalWrite(IN1, HIGH);
        digitalWrite(IN2, LOW);
        digitalWrite(IN3, HIGH);
        digitalWrite(IN4, LOW);
        break;

        case 'B':
        analogWrite(ENA, MIN_V);
        analogWrite(ENB, MIN_V);
        digitalWrite(IN1, LOW);
        digitalWrite(IN2, HIGH);
        digitalWrite(IN3, LOW);
        digitalWrite(IN4, HIGH);
        break;

        case 'R':
        analogWrite(ENA, MAX_V);
        analogWrite(ENB, MAX_V);
        digitalWrite(IN1, HIGH);
        digitalWrite(IN2, LOW);
        digitalWrite(IN3, LOW);
        digitalWrite(IN4, LOW);
        break;

        case 'L':
        analogWrite(ENA, MAX_V);
        analogWrite(ENB, MAX_V);
        digitalWrite(IN1, LOW);
        digitalWrite(IN2, LOW);
        digitalWrite(IN3, HIGH);
        digitalWrite(IN4, LOW);
        break;

        case 'G':
        analogWrite(ENA, MIN_V);
        analogWrite(ENB, MAX_V+400);
        digitalWrite(IN1, HIGH);
        digitalWrite(IN2, LOW);
        digitalWrite(IN3, HIGH);
        digitalWrite(IN4, LOW);
        break;

        case 'I':
        analogWrite(ENA, MAX_V+400);
        analogWrite(ENB, MIN_V);
        digitalWrite(IN1, HIGH);
        digitalWrite(IN2, LOW);
        digitalWrite(IN3, HIGH);
        digitalWrite(IN4, LOW);
        break;

        case 'V':
        digitalWrite(SolenoidPIN, HIGH);
        delay(100);
        digitalWrite(SolenoidPIN, LOW);

        case 'H':
        analogWrite(ENA, MIN_V);
        analogWrite(ENB, MAX_V+400);
        digitalWrite(IN2, HIGH);
        digitalWrite(IN1, LOW);
        digitalWrite(IN4, HIGH);
        digitalWrite(IN3, LOW);
        break;

        case 'J':
        analogWrite(ENA, MAX_V+400);
        analogWrite(ENB, MIN_V);
        digitalWrite(IN2, HIGH);
        digitalWrite(IN1, LOW);
        digitalWrite(IN4, HIGH);
        digitalWrite(IN3, LOW);
        break;

        case 'q':
        t = !t;
      }
     }
}
