#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WebServer.h>

void PUSH();
void new_page();
void new_Setup();
void new_Getsetup();

void new_TURBO();//прототип финкции турбо//
void new_GO();//прототип функции вперед//
void new_BACK();//прототип функции назад//
void new_LEFT();//прототип функции налево//
void new_RIGHT();//прототип функции направо//
void new_STOP();//прототип функции остановиться//

int MAX_POSSIBLE_V=1024;
int MAX_VPODRULIVANIE=1000;
int MAX_V_DISCRET_POVOROT=1000;
int MAX_V=1000; //600
int MIN_V=600; //300
int ACCEL = 1;
int ACCEL_ROTATION = 1;
int ACCEL_STEP = 10;
int ACCEL_PODRULIVANIE = 1;
int DELAY_PODRULIVANIE = 0;

int ENA = 16; // ENA=16 для 101 с глючным пином, ENA=4 для всех остальных
int IN1 = 0; 
int IN2 = 2;

int ENB = 14;
int IN3 = 12; 
int IN4 = 13;

int SolenoidPIN = 15;//D8

const char* ssid = "botnetcam";
const char* password = "12345678990";

ESP8266WebServer server(80);   //instantiate server at port 80 (http port)


String page = "";//объявляем переменнную типа стринг


void setup(void) {
  // put your setup code here, to run once:
  pinMode(ENA, OUTPUT);
  pinMode(IN1, OUTPUT);
  pinMode(IN2, OUTPUT);
  
  pinMode(ENB, OUTPUT);
  pinMode(IN3, OUTPUT);
  pinMode(IN4, OUTPUT);
pinMode (SolenoidPIN, OUTPUT); // пин для соленоида
digitalWrite (SolenoidPIN, LOW); // выключаем соленоид, чтобы не грелся

  delay(1000);
  Serial.begin(115200);//монитор серийного порта 
  WiFi.begin(ssid, password); //begin WiFi connection
  Serial.println("");

  // Wait for connection
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

/////////////////////////////////////
new_page();
////////////////////////////////////

//отвечает за изменение скорости//
new_Setup();
  

new_Getsetup();

  
//это метод написания кода для того чтобы машинка ускорилась//
new_TURBO();
new_GO();
new_BACK();
new_LEFT();
new_RIGHT();
PUSH();
new_STOP();

//это метод написания кода для того чтобы машинка поехала вперед//




  
  server.begin();
  Serial.println("Web server started!");
  

}//конец функции setup//


void new_LEFT(){
      server.on("/LEFT", [](){ //это метод написания кода для того чтобы машинка поехала налево//
    server.send(200, "text/html", "&larr;</font></center>");
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V_DISCRET_POVOROT;i>-1;i=i-3)
       {
        analogWrite(ENB, i);
        delay(ACCEL_ROTATION);
       }
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });}
void new_RIGHT(){
    server.on("/RIGHT", [](){ //это метод написания кода для того чтобы машинка поехала направо//
    server.send(200, "text/html","&rarr;</font></center>");
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V_DISCRET_POVOROT;i>-1;i=i-3)
       {
         analogWrite(ENA, i);
         delay(ACCEL_ROTATION);
       }
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });}
void new_STOP(){
    server.on("/STOP", [](){ 
    server.send(200, "text/html","&#10006;");
    for(int i=MIN_V;i>-1;i--)
       {
         analogWrite(ENA, i);
         analogWrite(ENB, i);
         delay(ACCEL);
       }
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });}

void new_BACK(){
    server.on("/BACK", [](){ //это метод написания кода для того чтобы машинка поехала назад//
    server.send(200, "text/html", "&darr;</font></center>");
    analogWrite(ENA, 0);
    analogWrite(ENB, 0);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, HIGH);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, HIGH);
    for(int i=MAX_V;i>MIN_V;i--)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, i);
        delay(ACCEL);     
       }
  });}
void new_page(){
    page="<!DOCTYPE html><html><head><title></title><link href=\"https://fonts.googleapis.com/css?family=Lato\" rel=\"stylesheet\"><script src=\"https://code.jquery.com/jquery-3.5.1.min.js\"integrity=\"sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=\"crossorigin=\"anonymous\"></script><script type=\"text/javascript\"src=\"http://ajax.googleapis.com/ajax/libs/jquery/1.9.0/jquery.min.js\"></script><script type=\"text/javascript\">$(document).ready(function(){$(\"#GO\").click(function(){$(\"#START\").load(\"/GO\");});$(\"#BACK\").click(function(){$(\"#START\").load(\"/BACK\");});$(\"#LEFT\").click(function(){$(\"#START\").load(\"/LEFT\");});$(\"#RIGHT\").click(function(){$(\"#START\").load(\"/RIGHT\");});$(\"#LEFT2\").click(function(){$(\"#LEFT2\").load(\"/LEFT2\");});$(\"#RIGHT2\").click(function(){$(\"#RIGHT2\").load(\"/RIGHT2\");});$(\"#TURBO\").click(function(){$(\"#START\").load(\"/TURBO\");});$(\"#STOP\").click(function(){$(\"#START\").load(\"/STOP\");});$(\"#PUSH\").click(function(){$(\"#START\").load(\"PUSH\");});});</script><style type=\"text/css\">#PUSH{position:absolute;top:260px;right:280px;border:2px solid #03e9f4}#BACK{position:absolute;top:260px;left:280px;border:2px solid #03e9f4}#GO{position: absolute;top:110px;left:280px;border:2px solid #03e9f4}#STOP{position: absolute;top:30px;left:90px;border:2px solid #03e9f4}#TURBO{position: absolute;top:30px;right: 80px;border:2px solid #03e9f4}#START{font-size:500%;top:200px;width:400px;}button:focus {outline: none;}#LEFT{position: absolute;top:180px;right:280px;border:2px solid #03e9f4}#RIGHT{position: absolute;top:180px;right:100px;border:2px solid #03e9f4}@import url('https://fonts.googleapis.com/css2?family=Raleway:wght@400;700&display=swap');*{margin: 0;padding: 0;box-sizing: border-box;}body{display: flex;justify-content: center;align-items: center;height: 100vh;background: black;font-family: 'Raleway', sans-serif;font-weight: bold;}button{width: 170px;position: relative;display: inline-block;padding: 25px 30px;color: #03e9f4;background-color: black;border:0px solid black;text-decoration: none;text-transform: uppercase;transition: 0.5s;letter-spacing: 4px;overflow: hidden;margin-right: 10px;}#START{background: #03e9f4;color: #050801;box-shadow: 0 0 5px #03e9f4,0 0 25px #03e9f4,0 0 50px #03e9f4,0 0 200px #03e9f4;-webkit-box-reflect:below 1px linear-gradient(transparent, #0005);}button:hover{background: #03e9f4;color: #050801;box-shadow: 0 0 5px #03e9f4,0 0 25px #03e9f4,0 0 50px #03e9f4,0 0 200px #03e9f4;-webkit-box-reflect:below 1px linear-gradient(transparent, #0005);}button:nth-child(1){fiue-rotate(270deg);}button:nth-child(2){filter: hue-rotate(110deg);}button span{position: absolute;display: block;}button span:nth-child(1){top: 0;left: 0;width: 100%height: 2px;background: linear-gradient(90deg,transparent,#03e9f4);animation: animate1 1s linear infinite;}@keyframes animate1{0%{left: -100%;}50%,100%{left: 100%;}}button span:nth-child(2)K{top: -100%;right: 0;width: 2px;height: 100%;background: linear-gradient(180deg,transparent,#03e9f4);animation: animate2 1s linear infinite;animation-delay: 0.25s;}@keyframes animate2{0%{top: -100%;}50%,100%{top: 100%;}}button span:nth-child(3){bottom: 0;right: 0;width: 100%;height: 2px;background: linear-gradient(270deg,transparent,#03e9f4);animation: animate3 1s linear infinite;animation-delay: 0.50s;}@keyframes animate3{0%{right: -100%;}50%,100%{right: 100%;}}button span:nth-child(4){bottom: -100%;left: 0;width: 2px;height: 100%;background: linear-gradient(360deg,transparent,#03e9f4);animation: animate4 1s linear infinite;animation-delay: 0.75s;}@keyfamsanimate4{0%{bottom: -100%;}50%,100%{bottom: 100%;}}body {width: 100%;height: 100%;position: fixed;background-color: black;}.content {position: absolute ;top: 100px;left: 50%;transform: translate(-50%, -50%);height: 50px;overflow: hidden;font-family: 'Lato', sans-serif;font-size: 35px;line-height: 40px;color: #ecf0f1;}.content__container {font-weight: 600;overflow: hidden;height: 40px;padding: 0 40px;}.content__container:before {content: '{';left: 0;}.content__container:after {content: '}';: absolute;right: 0;}.content__container:after, .content__container:before {position: absolute;top: 0;color: black;<!-- отвечает за цвет рамок -->font-size: 42px;line-height: 40px;-webkit-animation-name: opacity;-webkit-animation-duration: 3s;-webkit-animation-iteration-count: infinite;animation-name: opacity;animation-duration: 3s;animation-iteration-count: infinite;}.content__container__text {display: inline;float: left;margin: 0;color:red;<!-- отвечает за цвет текста -->}.content__container__list {margin-top: -1px;padding-left: 110px;text-align: left;list-style: none;-webkit-animation-name: change;-webkit-animation-duration: 12s;-webkit-animation-iteration-count: infinite;animation-name: change;animation-duration: 12sanimation-iteration-count: infinite;}.content__container__list__item {line-height:40px;margin: 0;}@-webkit-keyframes opacity {0%, 100% {opacity: 0;}50% {opacity: 1;}}@-webkit-keyframes change{0%, 12.66%, 100% {transform: translate3d(0, 0, 0);}16.66%, 29.32% {transform: translate3d(0, -25%, 0);}33.32%, 45.98% {transform: translate3d(0, -50%, 0);}49.98%, 62.64% {transform: translate3d(0, -75%, 0);}66.64%, 79.3% {transform: translate3d(0, -50%, 0);}83.3%, 95.96% {transform: translate3d(0, -25%, 0);}}@-o-keyframes opacity {0%, 100% {opacity: 0;}50% {opacity: 1;}}@-o-keyframes change {0%, 12.66%, 100% {transform: translate3d(0, 0, 0);}16.66%, 29.32% {transform: translate3d(0, -25%, 0);}33.32%, 45.98% {transform: translate3d(0, -50%, 0);}49.98%, 62.64% {transform: translate3d(0, -75%, 0);}66.64%, 79.3% {transform: translate3d(0, -50%, 0);}83.3%, 95.96% {transform: translate3d(0, -25%, 0);}}@-moz-keyframes opacity {0%, 100% {opacity: 0;}50% {opacity: 1;}}@-moz-keyframes change {0%, 12.66%, 100% {transform: translate3d(0, 0, 0);}16.66%, 29.32% {transform: translate3d(0, -25%, 0);}33.32%, 45.98% {transform: translate3d(0, -50%, 0);}49.98%, 62.64% {transform: translate3d(0, -75%, 0);}66.64%, 79.3% {transform: translate3d(0, -50%, 0);}83.3%, 95.96% {transform: translate3d(0, -25%, 0);}}@keyframes opacity {0%, 100% {opacity: 0;}50% {opacity: 1;}}@keyframes change {0%, 12.66%, 100% {transform: translate3d(0, 0, 0);}16.66%, 29.32% {transform: translate3d(0, -25%, 0);}33.32%, 45.98% {transform: translate3d(0, -50%, 0);}49.98%, 62.64% {transform: translate3d(0, -75%, 0);}66.64%, 79.3% {transform: translate3d(0, -50%, 0);}83.3%, 95.96% {transform: translate3d(0, -25%, 0);}}</style></head><body><head><div class=\"content\"><div class=\"content__container\"><p class=\"content__container__text\">TEAM</p><ul class=\"content__container__list\"><li class=\"content__container__list__item\" style=\"color:#DAA520;\">Programm KING</li><li class=\"content__container__list__item\"  style=\"color:#03e9f4;\">Team-liad:Sofiya</li><li class=\"content__container__list__item\" style=\"color:#00FF00;\">Designer:Nastya</li><li class=\"content__container__list__item\"  style=\"color:#03e9f4;\">Engineer:Daniil</li></ul></div></div></head><body><center><div><button id=\"BACK\">BACK</button ><button id=\"TURBO\" >TURBO</button ><button id=\"LEFT\" >LEFT</button></div> <button id=\"GO\" >GO</button><button id=\"RIGHT\" >RIGHT</button><button id=\"STOP\">STOP</button><button id=\"PUSH\">PUSH</button><button id=\"START\"><span></span><span></span><span></span>&#9883;</button></body></html>";

server.on("/", [](){
    server.send(200, "text/html", page);
  });
}

void new_Setup(){  server.on("/SETUP", [](){ 
  //usage: http://ip/SETUP?maxv=1000&minv=500
  String maxv_val = server.arg("maxv");
  String minv_val = server.arg("minv");
  MAX_V = maxv_val.toInt();
  MIN_V = minv_val.toInt(); 
  server.send(200,"text/html","BOT "+String(WiFi.localIP()[3])+"<br>WARNING: Possible value of MAX_V=1024;<br><br> Current set up:<br> MAX_V= " + String(MAX_V) + "<br>MIN_V= " + String(MIN_V)); 
  });}
void new_Getsetup(){  server.on("/GETSETUP", [](){
  //usage: http://ip/GETSETUP
  server.send(200,"text/html","BOT "+String(WiFi.localIP()[3])+" calibration values:<br>MAX_V= " + String(MAX_V) + ";<br>MIN_V= " + String(MIN_V)); 
  });}


void new_TURBO()
  {
    server.on("/TURBO", [](){ 
    server.send(200, "text/html", "&uarr; &uarr;");
    analogWrite(ENA, 0);
    analogWrite(ENB, 0);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MIN_V;i<MAX_POSSIBLE_V;i++)
   
       {
        analogWrite(ENA, i);
        analogWrite(ENB, i);
        delay(ACCEL);     
       }
  });}

void PUSH(){
   server.on("/PUSH", [](){
    server.send(200, "text/html","&#9773;</font></center>");
    // Тимур: удар толкателя
    digitalWrite(SolenoidPIN, HIGH);// соленоид вперед
    delay(100);
    digitalWrite(SolenoidPIN, LOW);// соленоид назад
  });
}

void new_GO(){
    server.on("/GO", [](){ 
    server.send(200, "text/html", " &uarr;</center></span>");
    analogWrite(ENA, 0);
    analogWrite(ENB, 0);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V;i>MIN_V;i--)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, i);
        delay(ACCEL);     
       }
  });}

void loop(void) {
  // put your main code here, to run repeatedly:
   server.handleClient();

}
