#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266WebServer.h>
#include <SoftwareSerial.h>

int MAX_POSSIBLE_V=1024;
int MAX_VPODRULIVANIE=1000;
int MAX_V_DISCRET_POVOROT=700;
int MAX_V=600; //600
int MIN_V=300; //300
int ACCEL = 2; //1
int ACCEL_ROTATION = 3; //1
int ACCEL_STEP = 10;
int ACCEL_PODRULIVANIE = 3;
int DELAY_PODRULIVANIE = 0;

int ENA = 16; // ENA=16 для 101 с глючным пином, ENA=4 для всех остальных
int IN1 = 0; 
int IN2 = 2;

int ENB = 14;
int IN3 = 12; 
int IN4 = 13;

int SolenoidPIN = 15; //D8

const char* ssid = "botnetcam";
const char* password = "12345678990";
 
ESP8266WebServer server(80);   //instantiate server at port 80 (http port)
SoftwareSerial btSerial(D1, D2);

String page = "";
void setup(void){

  pinMode(ENA, OUTPUT);
  pinMode(IN1, OUTPUT);
  pinMode(IN2, OUTPUT);
  
  pinMode(ENB, OUTPUT);
  pinMode(IN3, OUTPUT);
  pinMode(IN4, OUTPUT);

  pinMode(SolenoidPIN, OUTPUT); // пин для соленоида
  digitalWrite(SolenoidPIN, LOW); // выключаем соленоид чтобы не грелся
  
  //make the LED pin output and initially turned off
  //pinMode(LED_BUILTIN, OUTPUT);
  //digitalWrite(LED_BUILTIN, LOW);
   
  delay(1000);
  Serial.begin(9600);
  btSerial.begin(9600);
  WiFi.begin(ssid, password); //begin WiFi connection
  Serial.println("");
 
  // Wait for connection
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());
  
  //the HTML of the web page
  page = "<center><font size=\"7\">STUDY BOT "+String(WiFi.localIP()[3])+"<br><br><a href=\"KICK\">KICK</a><br><br><a href=\"ACCEL\">ACCELERATE</a><br><br><a href=\"GO\">GO</a><br><br><a href=\"STOP\">STOP</a><br><br><a href=\"BACK\">BACK</a><br><br><a href=\"LEFT\">LEFT</a>&nbsp;&nbsp;&nbsp;<a href=\"RIGHT\">RIGHT</a><br><br><a href=\"LEFT2\">LEFT2</a>&nbsp;&nbsp;&nbsp;<a href=\"RIGHT2\">RIGHT2</a><br>";
  
  
  
  server.on("/", [](){
    server.send(200, "text/html", page+"</font></center>");
  });


  server.on("/SETUP", [](){
  //usage: http://ip/SETUP?maxv=1000&minv=500
  String maxv_val = server.arg("maxv");
  String minv_val = server.arg("minv");
  MAX_V = maxv_val.toInt();
  MIN_V = minv_val.toInt(); 
  server.send(200,"text/html","BOT "+String(WiFi.localIP()[3])+"<br>WARNING: Possible value of MAX_V=1024;<br><br> Current set up:<br> MAX_V= " + String(MAX_V) + "<br>MIN_V= " + String(MIN_V)); 
  });

  server.on("/GETSETUP", [](){
  //usage: http://ip/GETSETUP
  server.send(200,"text/html","BOT "+String(WiFi.localIP()[3])+" calibration values:<br>MAX_V= " + String(MAX_V) + ";<br>MIN_V= " + String(MIN_V)); 
  });


  server.on("/ACCEL", [](){
    server.send(200, "text/html", page+"&uarr;</font></center>");
    analogWrite(ENA, 0);
    analogWrite(ENB, 0);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MIN_V;i<MAX_POSSIBLE_V;i++)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, i);
        delay(ACCEL);     
       }
  });
  server.on("/KICK", [](){
    server.send(200, "text/html", page+"&uarr;</font></center>");
    // Тимур: удар толкателя
    digitalWrite(SolenoidPIN, HIGH);// соленоид вперед
    delay(100);
    digitalWrite(SolenoidPIN, LOW);// соленоид назад
  });
  
  server.on("/GO", [](){
    server.send(200, "text/html", page+"&uarr;</font></center>");
    
    analogWrite(ENA, 0);
    analogWrite(ENB, 0);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=0 ;i<MIN_V;i++)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, i);
        delay(ACCEL);     
       }
  });

  server.on("/BACK", [](){
    server.send(200, "text/html", page+"&darr;</font></center>");
    analogWrite(ENA, 0);
    analogWrite(ENB, 0);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, HIGH);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, HIGH);
    for(int i=MAX_V;i>MIN_V;i--)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, i);
        delay(ACCEL);     
       }
  });

  
  server.on("/STOP", [](){
    server.send(200, "text/html", page+"_</font></center>");
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });
  server.on("/RIGHT", [](){
    server.send(200, "text/html", page+"&rarr;</font></center>");
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, HIGH);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V_DISCRET_POVOROT;i>-1;i=i-3)
       {
         analogWrite(ENA, i);
         delay(ACCEL_ROTATION);
       }
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });
    server.on("/LEFT", [](){
    server.send(200, "text/html", page+"&larr;</font></center>");
    analogWrite(ENA, MAX_V);
    analogWrite(ENB, MAX_V);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, HIGH);
    digitalWrite(IN4, LOW);
    for(int i=MAX_V_DISCRET_POVOROT;i>-1;i=i-3)
       {
        analogWrite(ENB, i);
        delay(ACCEL_ROTATION);
       }
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
  });



//----------------------- Podrul--


 server.on("/LEFT2", [](){
    server.send(200, "text/html", page+"+ &rarr;</font></center>");
    for(int i=MIN_V;i<MAX_VPODRULIVANIE+1;i=i+ACCEL_STEP)
       {
        analogWrite(ENB, i);
        analogWrite(ENA, 2*MIN_V-i);
        delay(ACCEL_PODRULIVANIE);
       }   
    delay(DELAY_PODRULIVANIE); 
    for(int i=MAX_VPODRULIVANIE;i>MIN_V-1;i=i-ACCEL_STEP)
       {
        analogWrite(ENB, i);
        analogWrite(ENA, 2*MIN_V-i);
        delay(ACCEL_PODRULIVANIE);
       }
  });
    server.on("/RIGHT2", [](){
    server.send(200, "text/html", page+ "+ &larr;</font></center>");
    for(int i=MIN_V;i<MAX_VPODRULIVANIE+1;i=i+ACCEL_STEP)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, 2*MIN_V-i);
        delay(ACCEL_PODRULIVANIE);
       }   
    delay(DELAY_PODRULIVANIE);
    for(int i=MAX_VPODRULIVANIE;i>MIN_V-1;i=i-ACCEL_STEP)
       {
        analogWrite(ENA, i);
        analogWrite(ENB, 2*MIN_V-i);
        delay(ACCEL_PODRULIVANIE);
       }
  });

//--------------------------------- end podrul ---
  
  server.begin();
  Serial.println("Web server started!");
}
 
void loop(void){
  server.handleClient();
  //Serial.println(".");
  
  if (btSerial.available() > 0) {
     char data = btSerial.read();
     Serial.println("----->"+String(data));
    
    
    
    switch (data)
     {
      case 'F':
      Serial.println("------------------go");
      analogWrite(ENA, MIN_V);
      analogWrite(ENB, MIN_V);
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, HIGH);
      digitalWrite(IN4, LOW);
      break;
      case 'B':
      Serial.println("------------------back");
      analogWrite(ENA, MIN_V);
      analogWrite(ENB, MIN_V);
      digitalWrite(IN1, LOW);
      digitalWrite(IN2, HIGH);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, HIGH);
      break;
      case 'R':      
      Serial.println("------------------right");
      analogWrite(ENA, MIN_V);
      analogWrite(ENB, MIN_V);
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, LOW);
      break;
      case 'L':      
      Serial.println("------------------left");
      analogWrite(ENA, MIN_V);
      analogWrite(ENB, MIN_V);
      digitalWrite(IN1, LOW);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, HIGH);
      digitalWrite(IN4, LOW);
      break;
      case 'S':
      Serial.println("------------------>stop");
      digitalWrite(IN1, LOW);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, LOW);
      break;
      case 'K':
      Serial.println("------------------>kick");
      digitalWrite(SolenoidPIN, HIGH);
      delay(100);
      digitalWrite(SolenoidPIN, LOW);
      break;
      default:
      break;
    }
  }
}
