#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WebServer.h>
#include <SoftwareSerial.h>

int MAX_POSSIBLE_V=1024;
int MAX_VPODRULIVANIE=900;
int MAX_V_DISCRET_POVOROT=500;
int MAX_V=400; //600
int MIN_V=0; //300
int ACCEL = 1;
int ACCEL_ROTATION = 1;
int ACCEL_STEP = 10;
int ACCEL_PODRULIVANIE = 1;
int DELAY_PODRULIVANIE = 0;
int ROTATION = 200;
int RT_M = 100;

int ENA = 16; // ENA=16 РґР»СЏ 101 СЃ РіР»СЋС‡РЅС‹Рј РїРёРЅРѕРј, ENA=4 РґР»СЏ РІСЃРµС… РѕСЃС‚Р°Р»СЊРЅС‹С…
int IN1 = 0; 
int IN2 = 2;

int ENB = 14;
int IN3 = 12; 
int IN4 = 13;

int rot = 0;

int SolPin = 15;

const char* ssid = "botnetcam";
const char* password = "12345678990";
String page = "";
int data_go = 0;

ESP8266WebServer server(80);   //instantiate server at port 80 (http port)
SoftwareSerial btSerial(5, 4);
//String page = "";
void setup(void){

  pinMode(ENA, OUTPUT);
  pinMode(IN1, OUTPUT);
  pinMode(IN2, OUTPUT);
  
  pinMode(ENB, OUTPUT);
  pinMode(IN3, OUTPUT);
  pinMode(IN4, OUTPUT);

  pinMode(SolPin, OUTPUT);
  
  //make the LED pin output and initially turned off
  //pinMode(LED_BUILTIN, OUTPUT);
  //digitalWrite(LED_BUILTIN, LOW);
   
  delay(1000);
  Serial.begin(9600);     
  btSerial.begin(9600); 
  //wifi
  WiFi.begin(ssid, password); //begin WiFi connection
  Serial.println("");
  
 
  // Wait for connection
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.print("Connected to ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());
  
  //the HTML of the web page
  page = "<link rel=\"stylesheet\" href=\"https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css\" integrity=\"sha384-JcKb8q3iqJ61gNV9KGb8thSsNjpSL0n8PARn9HuZOnIxN0hoP+VmmDGMN5t9UJ0Z\" crossorigin=\"anonymous\"><center><button type=\"button\" class=\"btn btn-danger\" onclick='document.location.href=\"PUSH\"'>THE RED BUTTON</button><br><br><button type=\"button\" class=\"btn btn-danger\" onclick='document.location.href=\"GO\"'>GO</button><br><br><button type=\"button\" class=\"btn btn-danger\" onclick='document.location.href=\"BACK\"'>BACK</button><br><br><button type=\"button\" class=\"btn btn-danger\" onclick='document.location.href=\"STOP\"'>STOP</button><br><br><button type=\"button\" class=\"btn btn-danger\" onclick='document.location.href=\"LEFT\"'>Left</button>&nbsp;&nbsp;&nbsp;<button type=\"button\" class=\"btn btn-danger\" onclick='document.location.href=\"RIGHT\"'>RIGHT</button>";
  
  
  
  server.on("/", [](){
    server.send(200, "text/html", page+"</font></center>");
  });


  server.on("/GO", [](){
      server.send(200, "text/html", page+"&uarr;</font></center>");
      Forward();
  });

  server.on("/PUSH", [](){
      server.send(200, "text/html", page+"</font></center>");
      Push();
  });

  server.on("/BACK", [](){
    server.send(200, "text/html", page+"&darr;</font></center>");
    Backward();
  });

  
  server.on("/STOP", [](){
    server.send(200, "text/html", page+"_</font></center>");
    Stop();
  });
  server.on("/RIGHT", [](){
    server.send(200, "text/html", page+"&rarr;</font></center>");
    Right(1);
  });
    server.on("/LEFT", [](){
    server.send(200, "text/html", page+"&larr;</font></center>");
    Left(-1);
  });
  
  server.begin();
  Serial.println("Web server started!");
}
 
void loop(void){
  server.handleClient();
  if (btSerial.available() > 0) {    
    char data = btSerial.read();  // СЃС‡РёС‚Р°С‚СЊ РґР°РЅРЅС‹Рµ РёР· HC-05
    Serial.println("->"+String(data));
    Serial.println("->"+String(data_go));
    if (data == 'N'){
      data_go = 1;
      Forward();
      rot = 0;
    }else if(data == 'S'){
      rot = 0;
      data_go = 2;
      Backward();
    }else if(data == 'W'){
      rot = rot - 1;
      if (data_go == 1){
        ForwL(rot);
        //Serial.println("ForwL");
      }else if(data_go == 2){
        BackL(rot);
      }else{
        Left(rot);
      }
    }else if(data == 'E'){
      rot = rot + 1;
      if (data_go == 1){
        ForwR(rot);
      }else if(data_go == 2){
        BackR(rot);
      }else{
        Right(rot);
      }
    }else if(data == '4'){
      data_go = 0;
      rot = 0;
      Stop();
    }else if(data == '2'){
      Push();
    }else if(data == '3' && MAX_V < 925){
      MAX_V = MAX_V + 50;
      if (data_go == 1){
        Forward();
      }else if(data_go == 2){
        Backward();
      }
    }
    else if(data == '1' && MAX_V > 50){
      MAX_V = MAX_V - 50;
      if (data_go == 1){
        Forward();
      }else if(data_go == 2){
        Backward();
      }
    }
  }
}

void Forward(void){
  digitalWrite(IN1, LOW);
  digitalWrite(IN2, HIGH);
  digitalWrite(IN3, LOW);
  digitalWrite(IN4, HIGH);
  for(int i=MIN_V;i<MAX_V;i++)
  {
    analogWrite(ENA, i);
    analogWrite(ENB, i);
    delay(ACCEL);     
  }
}

void Stop(void){
  analogWrite(ENA, 0);
  analogWrite(ENB, 0);
  digitalWrite(IN1, LOW);
  digitalWrite(IN2, LOW);
  digitalWrite(IN3, LOW);
  digitalWrite(IN4, LOW);
}

void Backward(void){
  digitalWrite(IN1, HIGH);
  digitalWrite(IN2, LOW);
  digitalWrite(IN3, HIGH);
  digitalWrite(IN4, LOW);
  for(int i=MIN_V;i<MAX_V;i++)
  {
    analogWrite(ENA, i);
    analogWrite(ENB, i);
    delay(ACCEL);     
  }
}

void Right(int rot){
  digitalWrite(IN1, LOW);
  digitalWrite(IN2, HIGH);
  digitalWrite(IN3, HIGH);
  digitalWrite(IN4, LOW);
  for(int i=MIN_V;i<ROTATION*rot;i++)
  {
    analogWrite(ENA, i);
    analogWrite(ENB, i);
    delay(ACCEL);     
  }
}

void Left(int rot){
  rot = rot*(-1);
  digitalWrite(IN1, HIGH);
  digitalWrite(IN2, LOW);
  digitalWrite(IN3, LOW);
  digitalWrite(IN4, HIGH);
  for(int i=MIN_V;i<ROTATION*rot;i++)
  {
    analogWrite(ENA, i);
    analogWrite(ENB, i);
    delay(ACCEL);     
  }
}

void ForwR(int rot){
  digitalWrite(IN1, LOW);
  digitalWrite(IN2, HIGH);
  digitalWrite(IN3, LOW);
  digitalWrite(IN4, HIGH);
  analogWrite(ENA, MAX_V + rot*RT_M);
  analogWrite(ENB, MAX_V - rot*RT_M);
}

void BackR(int rot){
  digitalWrite(IN1, HIGH);
  digitalWrite(IN2, LOW);
  digitalWrite(IN3, HIGH);
  digitalWrite(IN4, LOW);
  analogWrite(ENA, MAX_V + rot*RT_M);
  analogWrite(ENB, MAX_V - rot*RT_M);
}

void ForwL(int rot){
  digitalWrite(IN1, LOW);
  digitalWrite(IN2, HIGH);
  digitalWrite(IN3, LOW);
  digitalWrite(IN4, HIGH);
  analogWrite(ENA, MAX_V + rot*RT_M);
  analogWrite(ENB, MAX_V - rot*RT_M);
}

void BackL(int rot){
  digitalWrite(IN1, HIGH);
  digitalWrite(IN2, LOW);
  digitalWrite(IN3, HIGH);
  digitalWrite(IN4, LOW);
  analogWrite(ENA, MAX_V + rot*RT_M);
  analogWrite(ENB, MAX_V - rot*RT_M);
}

    /*
    if (data_char == '1'){
      data = 1;
    }else if(data_char == '2'){
      data = 2;
    }else if(data_char == '3'){
      data = 3;
    }else if(data_char == '4'){
      data = 4;
    }else if(data_char == '5'){
      data = 5;
    }else if(data_char == '6'){
      data = 6;
    }else if(data_char == '7'){
      data = 7;
    }else if(data_char == '8'){
      data = 8;
    }else if(data_char == '9'){
      data = 9;
    }else if(data_char == '0'){
      data = 0;
    }
    
    Serial.println("->"+String(data_char));

    if (sharp == 0){
      if (data_char=='#'){
        sharp = 7;
        Serial.println("Num->"+String(num));
        Serial.println("Angle->"+String(angle));
        Serial.println("Strength->"+String(strength));
        DO(angle, strength);
        num = 0;
        angle = 0;
        strength = 0;
      }
    }else if(sharp != -1  ){
        if (sharp >= 5){
          if (data != 0){
            //Serial.println("1>"+String(data));
            //Serial.println("1>"+String(num));
            angle = angle + pow(10, sharp - 6) + data;
            num = num + pow(10, sharp-1) * data;
            //Serial.println("1->"+String(10 * (sharp-1)));
            //Serial.println("1->"+String(num));
          } 
        }else if(sharp<4){
          if (data != 0){
            //Serial.println("2>"+String(data));
            num = num + pow(10 , sharp-1) * data;
            strength = strength + pow(10, sharp-1) * data;
            //Serial.println("2->"+String(num));
          }
        }
    sharp = sharp - 1;
    }*/

    /*
 
    switch (data)
    {
      case '1':         // РµСЃР»Рё РїРѕР»СѓС‡РµРЅРЅС‹Рµ РґР°РЅРЅС‹Рµ B
        Serial.println("------------------>1");   // Р·Р°РїРёС€РµРј СЃС‚СЂРѕРєСѓ
        break;
      case '2':              // РµСЃР»Рё РїРѕР»СѓС‡РµРЅРЅС‹Рµ РґР°РЅРЅС‹Рµ S
        Serial.println("------------------>2");
        break;
      default:
        break;
    }*/
    //delay(70);
//  }
//}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
/*
void DO(int angle, int strength){
  Serial.println(String(strength));
  int alph = 0;
  //strength = strength * 0.75;
  if (angle == 0){
    Serial.println("1PUSH");
    if (strength>0){
      Serial.println("2PUSH");
      if (strength<4){
        Serial.println("PUSH");
        PUSH();
      }
    }
  }else if (strength == 4){
    analogWrite(ENA, 0);
    analogWrite(ENB, 0);
    digitalWrite(IN1, LOW);
    digitalWrite(IN2, LOW);
    digitalWrite(IN3, LOW);
    digitalWrite(IN4, LOW);
    delay(30);
  }else{
    Serial.println("GO");
    if (angle<45){
      alph = 45 - angle;//1 sec
      digitalWrite(IN1, LOW);
      digitalWrite(IN2, HIGH);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, HIGH);
      analogWrite(ENA, alph*strength/45);
      analogWrite(ENB, strength);
      delay(30);
    }else if(angle<90){//2 sec
      alph = angle - 45;
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, HIGH);
      analogWrite(ENA, alph*strength/45);
      analogWrite(ENB, strength);
      delay(30);
    }else if(angle<135){//3 sec
      alph = 135 - angle;
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, HIGH);
      analogWrite(ENA, strength);
      analogWrite(ENB, alph*strength/45);
      delay(30);
    }else if(angle<180){//4 sec
      alph = angle - 135;
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, HIGH);
      digitalWrite(IN4, LOW);
      analogWrite(ENA, strength);
      analogWrite(ENB, alph*strength/45);
      delay(30);
    }else if(angle<225){//5 sec
      alph = 225 - angle;
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, HIGH);
      digitalWrite(IN4, LOW);
      analogWrite(ENA, alph*strength/45);
      analogWrite(ENB, strength);
      delay(30);
    }else if(angle<270){// 6 sec
      alph = angle - 225;
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, HIGH);
      analogWrite(ENA, alph*strength/45);
      analogWrite(ENB, strength);
      delay(30);
    }else if(angle<315){//7 sec
      alph = 315 - angle;
      digitalWrite(IN1, HIGH);
      digitalWrite(IN2, LOW);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, HIGH);
      analogWrite(ENA, strength);
      analogWrite(ENB, alph*strength/45);
      delay(30);
    }else if(angle<360){
      alph = angle - 315;
      digitalWrite(IN1, LOW);
      digitalWrite(IN2, HIGH);
      digitalWrite(IN3, LOW);
      digitalWrite(IN4, HIGH);
      analogWrite(ENA, strength);
      analogWrite(ENB, alph*strength/45);
      delay(30);
    }
    
  }
}
*/
void Push(void){
  digitalWrite(SolPin, HIGH);
  delay(100);
  digitalWrite(SolPin, LOW);
}
