#include "iarduino_AM2320.h"

/*	НАЗНАЧЕНИЕ РЕГИСТРОВ ДАТЧИКА AM2320
	0x00	High humidity
	0x01	Low humidity
	0x02	High temperature
	0x03	Low temperature
	0x04	Retention
	0x05	Retention
	0x06	Retention
	0x07	Retention
	0x08	Model High
	0x09	Model Low
	0x0A	The version number
	0x0B	Device ID (24-31) Bit
	0x0C	Device ID (24-31) Bit
	0x0D	Device ID (24-31) Bit
	0x0E	Device ID (24-31) Bit
	0x0F	Status Register
	0x10	Users register a high
	0x11	Users register a low
	0x12	Users register 2 high
	0x13	Users register 2 low
	0x14	Retention
	0x15	Retention
	0x16	Retention
	0x17	Retention
	0x18	Retention
	0x19	Retention
	0x1A	Retention
	0x1B	Retention
	0x1C	Retention
	0x1D	Retention
	0x1E	Retention
	0x1F	Retention
*/

//		Функция инициализации датчика:
void	iarduino_AM2320::begin(void){
			objI2C->begin(100);																//	Инициируем работу по шине I2C на скорости 100 кГц
}																							//
																							//
//		Функция чтения данных датчика:														//
uint8_t	iarduino_AM2320::read(void){														//
			uint8_t data[8], result=10, len=0;												//
			uint16_t i;																		//
//			Не обращаемся к датчику чаще чем 1 раз в 0,5 сек.								//
			if( TIM_request>millis()||(TIM_request+500)<millis()){							//	Ксли зафиксировано переполнение millis() или прошло больше 0.5 сек после последнего обращения.
				TIM_request=millis(); result=AM2320_OK;										//	Разрешаем обратиться к датчику.
			}																				//
//			Будим датчик																	//
			if(result==AM2320_OK){															//	Если предыдущее условие разрешило обратиться к датчику.
				if(objI2C->checkAddress(VAR_address)==false){delay(2); result=AM2320_OK;}	//	Если датчик вернул NACK на получение собственного адреса, то ждём 2мс пока он проснётся.
			}																				//	(Датчик, получив свой адрес просыпается, но не отвечает на адрес. Проснувшись, он обновляет показания своих регистров. Только после этого он ответит на адрес.)
//			Отправляем запрос к датчику														//
			if(result==AM2320_OK){															//	Если предпредыдущее условие разрешило обратиться к датчику.
				uint8_t i[3]={0x03,0x00,0x04};												//	Определяем массив из 3 байт: 0x03 - команда чтения данных, 0x00 - адрес первого читаемого регистра, 0x04 - количество читаемых регистров.
				objI2C->writeBytes(VAR_address, i, 3);										//	Передаём датчику все элементы созданного массива.
			}																				//
//			Получаем ответ от датчика														//
			if(result==AM2320_OK){															//	Если предпредпредыдущее условие разрешило обратиться к датчику.
				if(!objI2C->readBytes(VAR_address, data, 8)){result=AM2320_ERROR_READ;}		//	Читаем 8 байт данных, без отправки байта адреса регистра. Если функция вернула false, значит данные не приняты или приняты не полностью.
			}																				//	(Ответ: команда, количество, 4 байта данных, 2 байта CRC)
//			Проверяем корректность ответа													//
			if(result==AM2320_OK){															//	Если предыдущее условие выполнено.
				if(data[0]!=0x03){result=AM2320_ERROR_ANS;}									//	Первый байт ответа является кодом команды на которую отвечает датчик. Если код команды не равен отправленной, значит принят ответ не соответствующий запросу.
				if(data[1]!=0x04){result=AM2320_ERROR_ANS;}									//	Второй байт ответа, для команды чтения, является количеством прочитанных регистров. Если количество на равно запрошенному, значит принят ответ не соответствующий запросу.
			}																				//
//			Проверяем CRC																	//
			if(result==AM2320_OK){															//	Если предыдущее условие выполнено.
				i=data[7]<<8; i+=data[6];													//	Преобразуем CRC датчика (он записан в последних 2 байтах ответа, при этом старший байт CRC является последним).
				if(i!=createCRC16(data,6)){result=AM2320_ERROR_LINE;}						//	Сравниваем  CRC датчика с вычисленным по 6 байтам принятого ответа.
			}																				//
//			Преобразуем полученные данные в значения температуры и влажности				//
			if(result==AM2320_OK){															//	Если предыдущее условие выполнено.
				i =data[2];      i<<=8; hum=i+data[3]; hum/=10;								//	Влажность   = data[2]data[3].
				i =data[4]&0x7F; i<<=8; tem=i+data[5]; tem/=10;								//	Температура = data[4]data[5], где старший бит указывает на знак (0-плюс, 1-минус).
				if(data[4]&0x80){tem*=-1;}													//	Добавляем знак к температуре.
			}																				//
			if(result==10){result=AM2320_OK;}												//	Запрет на обращение к датчику чаще 0.5 сек., не является ошибкой. Просто будут выведены предыдущие показания.
			return result;																	//
}																							//
																							//
//		Функция вычисления CRC16															//
uint16_t iarduino_AM2320::createCRC16(uint8_t *i, uint8_t j){								//
			uint16_t c=0xFFFF;																//	Предустанавливаем CRC в значение 0xFFFF
			for(uint8_t a=0; a<j; a++){														//	Проходим по элементам массива
				c^=i[a];																	//	Выполняем операцию XOR между CRC и очередным байтом массива i
				for(uint8_t b=0; b<8; b++){													//	Проходим по битам байта
					if(c & 0x01)	{c>>=1; c^=0xA001;	}									//	Сдвигаем значение crc на 1 байт вправо, если младший (сдвинутый) байт был равен 1, то
					else			{c>>=1;				}									//	Выполняем операцию XOR между CRC и полиномом 0xA001
				}																			//
			}																				//	По хорошему, в конце, надо выполнить операцию XOR между результатом CRC и значением 0xFFFF, но датчик этого не делает
			return c;																		//
}																							//